-- This file is part of Practical Distributed Processing
-- Copyright (C) 2006-2007 Phillip J. Brooke and Richard F. Paige

-- This file is part of Practical Distributed Processing
-- Copyright (C) 2006-2007 Phillip J. Brooke and Richard F. Paige

with Ada.Command_Line;
with Ada.Numerics.Float_Random;
with Ada.Text_IO;               use Ada.Text_IO;

procedure PC_EX2 is

   G : Ada.Numerics.Float_Random.Generator;

   Production_Time  : constant Float := 5.0;
   Consumption_Time : constant Float := 8.0;
   N_Producers      : constant Positive := 5;
   N_Consumers      : constant Positive := 3;

   protected Buffer is
      entry Producer_Push (F : in Float);
      entry Consumer_Push (F : out Float);
   private
      Available : Boolean := False;
      V         : Float;
   end Buffer;

   protected body Buffer is
      entry Producer_Push (F : in Float)
      when not Available is
      begin
         Available := True;
         V := F;
         Put_Line("push_data." & Float'Image(V) & " (producer to buffer)");
      end Producer_Push;

      entry Consumer_Push (F : out Float)
      when Available is
      begin
         Available := False;
         F := V;
         Put_Line("push_data." & Float'Image(F) & " (buffer to consumer)");
      end Consumer_Push;
   end Buffer;

   task type Producer;

   task type Consumer;

   task body Producer is
   begin
      loop
         delay Duration(Ada.Numerics.Float_Random.Random(G)
                        * Production_Time);
         Put_Line("create_data");
         Buffer.Producer_Push(Ada.Numerics.Float_Random.Random(G));
      end loop;
   end Producer;

   task body Consumer is
      F : Float;
   begin
      loop
         Buffer.Consumer_Push(F);
         delay Duration(Ada.Numerics.Float_Random.Random(G)
                        * Consumption_Time);
         Put_Line("use_data");
      end loop;
   end;

   Producers : array (1..N_Producers) of Producer;
   Consumers : array (1..N_Consumers) of Consumer;

begin
   null;
end PC_EX2;

